#lang racket

(define (die-simulator n roll-max)
  (define mod 1000000007)
  (define dp (make-vector (add1 n) (make-vector 6 (make-vector 16 0))))
  (for ([j (in-range 6)])
    (vector-set! (vector-ref dp 1) j 1))
  (for ([i (in-range 2 (add1 n))])
    (for ([j (in-range 6)])
      (for ([k (in-range 1 (vector-ref roll-max j))])
        (vector-set! (vector-ref (vector-ref dp i) j) k (vector-ref (vector-ref (vector-ref dp (sub1 i)) j) (sub1 k))))
      (vector-set! (vector-ref (vector-ref dp i) j) (vector-ref roll-max j) 0)
      (for ([p (in-range 6)])
        (when (not (= p j))
          (for ([k (in-range 1 16)])
            (vector-set! (vector-ref (vector-ref dp i) j) 1 
              (modulo (+ (vector-ref (vector-ref (vector-ref dp i) j) 1)
                       (vector-ref (vector-ref (vector-ref dp (sub1 i)) p) k))
              mod)))))
  (define total 0)
  (for ([j (in-range 6)])
    (for ([k (in-range 1 16)])
      (set! total (modulo (+ total (vector-ref (vector-ref (vector-ref dp n) j) k)) mod)))
  total)