(define (odd-cells m n indices)
  (let* ((matrix (make-vector m (make-vector n 0)))
    (for-each (lambda (index)
                (let ((ri (car index))
                  (vector-set! matrix ri (vector-map (lambda (x) (+ x 1)) (vector-ref matrix ri))))
                (let ((ci (cadr index))
                  (for ([i (in-range m)])
                    (vector-set! (vector-ref matrix i) ci (+ (vector-ref (vector-ref matrix i) ci) 1)))))
              indices)
    (for/sum ([row (in-vector matrix)])
      (for/sum ([val (in-vector row)])
        (if (odd? val) 1 0)))))