(define/contract (closed-island grid)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define m (length grid))
  (define n (if (zero? m) 0 (length (car grid))))
  (define (dfs i j)
    (if (or (< i 0) (>= i m) (< j 0) (>= j n))
        #f
        (if (zero? (list-ref (list-ref grid i) j))
            (begin
              (list-set! (list-ref grid i) j 1)
              (define top (dfs (sub1 i) j))
              (define bottom (dfs (add1 i) j))
              (define left (dfs i (sub1 j)))
              (define right (dfs i (add1 j)))
              (and top bottom left right))
            #t)))
  (define count 0)
  (for ([i (in-range m)])
    (for ([j (in-range n)])
      (when (zero? (list-ref (list-ref grid i) j))
            (when (dfs i j)
              (set! count (add1 count))))))
  count)