(define (max-score-words words letters score)
  (let* ((letter-count (make-vector 26 0))
         (n (length words))
         (max-score 0))
    (for ([c letters])
      (let ((idx (- (char->integer c) (char->integer #\a))))
        (vector-set! letter-count idx (+ (vector-ref letter-count idx) 1))))

    (define (can-form-word? word counts)
      (let ((temp (vector-copy counts)))
        (for/and ([c word])
          (let ((idx (- (char->integer c) (char->integer #\a))))
            (if (> (vector-ref temp idx) 0)
                (begin
                  (vector-set! temp idx (- (vector-ref temp idx) 1))
                  #t)
                #f)))))

    (define (calculate-score word)
      (for/sum ([c word])
        (vector-ref score (- (char->integer c) (char->integer #\a)))))

    (define (backtrack start current-counts current-score)
      (set! max-score (max max-score current-score))
      (for ([i (in-range start n)])
        (let ((word (list-ref words i)))
          (if (can-form-word? word current-counts)
              (let* ((new-counts (vector-copy current-counts))
                     (word-score 0))
                (for ([c word])
                  (let ((idx (- (char->integer c) (char->integer #\a))))
                    (vector-set! new-counts idx (- (vector-ref new-counts idx) 1))
                    (set! word-score (+ word-score (vector-ref score idx)))))
                (backtrack (+ i 1) new-counts (+ current-score word-score)))))))

    (backtrack 0 letter-count 0)
    max-score))