#lang racket

(require racket/set)

(define (find-ladders begin-word end-word word-list)
  (define word-set (list->set word-list))
  (unless (set-member? word-set end-word) (return '()))
  (define (neighbors word)
    (for*/list ([i (in-range (string-length word))]
                [c (in-string "abcdefghijklmnopqrstuvwxyz")]
                #:unless (char=? c (string-ref word i))
                (let ([new-word (string-copy word)])
                  (string-set! new-word i c)
                  new-word)))
  (define (bfs)
    (define queue (mutable-set))
    (set-add! queue begin-word)
    (define visited (mutable-set))
    (set-add! visited begin-word)
    (define parents (make-hash))
    (define found #f)
    (let loop ()
      (unless (or (set-empty? queue) found)
      (define level-size (set-count queue))
      (define current-level (mutable-set))
      (for ([i (in-range level-size)])
        (define word (set-first queue))
        (set-remove! queue word)
        (set-add! current-level word)
        (when (string=? word end-word)
          (set! found #t))
        (for ([neighbor (neighbors word)])
          (when (and (set-member? word-set neighbor)
                     (not (set-member? visited neighbor)))
            (hash-update! parents neighbor (lambda (v) (cons word v)) '())
            (set-add! queue neighbor)
            (set-add! visited neighbor))))
      (unless found (loop)))
    (if found parents #f))
  (define parents (bfs))
  (unless parents (return '()))
  (define (dfs word)
    (if (string=? word begin-word)
        (list (list word))
        (for*/list ([parent (hash-ref parents word '())]
                    [path (dfs parent)])
          (cons word path))))
  (dfs end-word))