(define/contract (palindrome-partitioning s k)
  (-> string? exact-integer? exact-integer?)
  (let* ([n (string-length s)]
         [cost (make-vector n (make-vector n 0))])
    (for ([i (in-range n)])
      (for ([j (in-range i n)])
        (let ([l i] [r j] [c 0])
          (while (< l r)
            (when (not (char=? (string-ref s l) (string-ref s r)))
              (set! c (add1 c)))
            (set! l (add1 l))
            (set! r (sub1 r)))
          (vector-set! (vector-ref cost i) j c))))
    (let ([dp (make-vector n (make-vector k +inf.0))])
      (for ([i (in-range n)])
        (vector-set! (vector-ref dp i) 0 (vector-ref (vector-ref cost 0) i))
      (for ([j (in-range 1 k)])
        (for ([i (in-range j n)])
          (vector-set! (vector-ref dp i) j +inf.0)
          (for ([m (in-range (sub1 i) -1 -1)])
            (vector-set! (vector-ref dp i) j
                         (min (vector-ref (vector-ref dp i) j)
                              (+ (vector-ref (vector-ref dp m) (sub1 j))
                                 (vector-ref (vector-ref cost (add1 m)) i)))))))
      (inexact->exact (vector-ref (vector-ref dp (sub1 n)) (sub1 k))))))