(define/contract (max-freq s max-letters min-size max-size)
  (-> string? exact-integer? exact-integer? exact-integer? exact-integer?)
  (define n (string-length s))
  (define freq (make-hash))
  (define max-count 0)
  (for ([i (in-range 0 (- n min-size -1))])
    (define substr (substring s i (+ i min-size)))
    (define unique-chars (list->set (string->list substr)))
    (when (<= (set-count unique-chars) max-letters)
      (hash-update! freq substr add1 0)
      (set! max-count (max max-count (hash-ref freq substr)))))
  max-count)