(define (roman-to-int s)
  (let ([roman-values (make-hash '((#\I . 1) (#\V . 5) (#\X . 10) (#\L . 50) 
                                  (#\C . 100) (#\D . 500) (#\M . 1000)))])
    (let loop ([i (- (string-length s) 1)] [prev 0] [total 0])
      (if (< i 0)
          total
          (let ([current (hash-ref roman-values (string-ref s i))])
            (if (< current prev)
                (loop (- i 1) current (- total current))
                (loop (- i 1) current (+ total current))))))))