(define (solve board)
  (let ((m (length board))
        (n (if (null? board) 0 (length (car board)))))
    (define (dfs i j)
      (when (and (>= i 0) (< i m) (>= j 0) (< j n) (char=? (list-ref (list-ref board i) j) #\O))
        (list-set! (list-ref board i) j #\T)
        (dfs (add1 i) j)
        (dfs (sub1 i) j)
        (dfs i (add1 j))
        (dfs i (sub1 j))))
    (for ([i (in-range m)])
      (dfs i 0)
      (dfs i (sub1 n)))
    (for ([j (in-range 1 (sub1 n))])
      (dfs 0 j)
      (dfs (sub1 m) j))
    (for ([i (in-range m)])
      (for ([j (in-range n)])
        (let ((cell (list-ref (list-ref board i) j)))
          (cond
            [(char=? cell #\O) (list-set! (list-ref board i) j #\X)]
            [(char=? cell #\T) (list-set! (list-ref board i) j #\O)])))))
    board))