(define/contract (partition s)
  (-> string? (listof (listof string?)))
  (define n (string-length s))
  (define (is-palindrome? l r)
    (let loop ([l l] [r r])
      (or (>= l r)
          (and (char=? (string-ref s l) (string-ref s r))
              (loop (add1 l) (sub1 r))))))
  (define (backtrack start path res)
    (if (= start n)
        (cons (reverse path) res)
        (for/fold ([res res])
                  ([end (in-range start n)])
          (if (is-palindrome? start end)
              (backtrack (add1 end)
                         (cons (substring s start (add1 end)) path)
                         res)
              res))))
  (reverse (backtrack 0 '() '())))