(define/contract (diagonal-sort mat)
  (-> (listof (listof exact-integer?)) (listof (listof exact-integer?)))
  (define m (length mat))
  (define n (if (null? mat) 0 (length (car mat))))
  (define (get-diagonal i j)
    (let loop ([i i] [j j] [res '()])
      (if (or (>= i m) (>= j n))
          (sort res <)
          (loop (add1 i) (add1 j) (cons (list-ref (list-ref mat i) j) res)))))
  (define (put-diagonal i j diag)
    (let loop ([i i] [j j] [diag diag])
      (if (and (< i m) (< j n) (not (null? diag)))
          (begin
            (set! mat (list-set mat i (list-set (list-ref mat i) j (car diag))))
            (loop (add1 i) (add1 j) (cdr diag)))
          mat)))
  (for ([i (in-range m)])
    (put-diagonal i 0 (get-diagonal i 0)))
  (for ([j (in-range 1 n)])
    (put-diagonal 0 j (get-diagonal 0 j)))
  mat)