(define/contract (find-the-city n edges distanceThreshold)
  (-> exact-integer? (listof (listof exact-integer?)) exact-integer? exact-integer?)
  (define dist (make-vector n (make-vector n +inf.0)))
  (for ([i n]) (vector-set! (vector-ref dist i) i 0))
  (for ([edge edges])
    (let ([u (first edge)]
          [v (second edge)]
          [w (third edge)])
      (vector-set! (vector-ref dist u) v w)
      (vector-set! (vector-ref dist v) u w)))
  (for ([k n])
    (for ([i n])
      (for ([j n])
        (let ([new-dist (+ (vector-ref (vector-ref dist i) k)
                           (vector-ref (vector-ref dist k) j))])
          (when (< new-dist (vector-ref (vector-ref dist i) j))
            (vector-set! (vector-ref dist i) j new-dist))))))
  (define min-count +inf.0)
  (define result -1)
  (for ([i (in-range (sub1 n) -1 -1)])
    (define count 0)
    (for ([j n])
      (when (and (not (= i j)) (<= (vector-ref (vector-ref dist i) j) distanceThreshold))
        (set! count (add1 count))))
    (when (< count min-count)
      (set! min-count count)
      (set! result i))
    (when (= count min-count)
      (set! result (max result i))))
  result)