(define/contract (k-weakest-rows mat k)
  (-> (listof (listof exact-integer?)) exact-integer? (listof exact-integer?))
  (define (row-strength row)
    (let loop ([low 0] [high (sub1 (length row))])
      (if (> low high)
          (add1 high)
          (let ([mid (quotient (+ low high) 2)])
            (if (zero? (list-ref row mid))
                (loop low (sub1 mid))
                (loop (add1 mid) high))))))
  )
  (let* ([rows-with-index (map (lambda (i row) (cons i (row-strength row))) 
                           (range 0 (length mat)) mat)]
         [sorted-rows (sort rows-with-index (lambda (a b) 
                                             (or (< (cdr a) (cdr b))
                                                 (and (= (cdr a) (cdr b)) (< (car a) (car b))))))])
    (map car (take sorted-rows k)))
)