(define/contract (min-steps s t)
  (-> string? string? exact-integer?)
  (let ((count (make-vector 26 0)))
    (for ((c (in-string s)))
      (vector-set! count (- (char->integer c) (char->integer #\a)) 
                   (add1 (vector-ref count (- (char->integer c) (char->integer #\a))))))
    (for ((c (in-string t)))
      (vector-set! count (- (char->integer c) (char->integer #\a)) 
                   (sub1 (vector-ref count (- (char->integer c) (char->integer #\a))))))
    (quotient (apply + (map abs (vector->list count))) 2)))