#lang racket

(require data/heap)

(define (min-cost grid)
  (define m (vector-length grid))
  (define n (if (zero? m) 0 (vector-length (vector-ref grid 0))))
  (when (or (zero? m) (zero? n)) (return 0))
  (define dirs '((1 0) (-1 0) (0 1) (0 -1)))
  (define costs (make-vector m (make-vector n +inf.0)))
  (define heap (make-heap (λ (a b) (<= (car a) (car b)))))
  (heap-add! heap (cons 0 0))
  (vector-set! (vector-ref costs 0) 0 0)
  (let loop ()
    (unless (heap-empty? heap)
      (define current (heap-min heap))
      (heap-remove-min! heap)
      (define cost (car current))
      (define pos (cdr current))
      (define i (quotient pos n))
      (define j (remainder pos n))
      (when (and (= i (sub1 m)) (= j (sub1 n)))
        (return cost))
      (for ([d (in-list dirs)])
        (define di (first d))
        (define dj (second d))
        (define ni (+ i di))
        (define nj (+ j dj))
        (when (and (>= ni 0) (< ni m) (>= nj 0) (< nj n))
          (define new-cost (+ cost (if (or (and (= di 1) (= dj 0) (= (vector-ref (vector-ref grid i) j) 1))
                                       (and (= di -1) (= dj 0) (= (vector-ref (vector-ref grid i) j) 2))
                                       (and (= di 0) (= dj 1) (= (vector-ref (vector-ref grid i) j) 3))
                                       (and (= di 0) (= dj -1) (= (vector-ref (vector-ref grid i) j) 4)))
                                    0 1)))
          (when (< new-cost (vector-ref (vector-ref costs ni) nj))
            (vector-set! (vector-ref costs ni) nj new-cost)
            (heap-add! heap (cons new-cost (+ (* ni n) nj)))))))
      (loop)))
  (vector-ref (vector-ref costs (sub1 m)) (sub1 n)))