(define/contract (copy-random-list head)
  (-> (or/c null? (box/c (list/c any/c (or/c null? (box/c any/c)) (or/c null? (box/c any/c)))))
      (or/c null? (box/c (list/c any/c (or/c null? (box/c any/c)) (or/c null? (box/c any/c))))))
  (if (null? head)
      null
      (let ([m (make-hash)])
        (let loop ([node head])
          (when (not (null? node))
            (hash-set! m node (box (list (car (unbox node)) null null)))
            (loop (caddr (unbox node)))))
        (let loop ([node head])
          (when (not (null? node))
            (let ([new-node (hash-ref m node)])
              (set-box! (cadr (unbox new-node)) (hash-ref m (cadr (unbox node)) null))
              (set-box! (caddr (unbox new-node)) (hash-ref m (caddr (unbox node)) null)))
            (loop (caddr (unbox node)))))
        (hash-ref m head null))))