(define/contract (max-performance n speed efficiency k)
  (-> exact-integer? (listof exact-integer?) (listof exact-integer?) exact-integer? exact-integer?)
  (define engineers (sort (for/list ([s speed] [e efficiency]) (cons e s)) > #:key car))
  (define pq (make-pqueue (lambda (a b) (< a b))))
  (define total-speed 0)
  (define max-perf 0)
  (for ([eng engineers])
    (define e (car eng))
    (define s (cdr eng))
    (pqueue-push! pq s)
    (set! total-speed (+ total-speed s))
    (when (> (pqueue-count pq) k)
      (set! total-speed (- total-speed (pqueue-pop! pq))))
    (set! max-perf (max max-perf (* total-speed e))))
  (modulo max-perf 1000000007))