(define/contract (sum-four-divisors nums)
  (-> (listof exact-integer?) exact-integer?)
  (define (divisors-sum n)
    (define limit (add1 (integer-sqrt n)))
    (define divisors (mutable-set))
    (for ([i (in-range 1 limit)])
      (when (zero? (modulo n i))
        (set-add! divisors i)
        (set-add! divisors (quotient n i))))
    (if (= (set-count divisors) 4)
        (apply + (set->list divisors))
        0))
  (apply + (map divisors-sum nums)))