#lang racket

(define (find-good-strings n s1 s2 evil)
  (define mod 1000000007)
  (define m (string-length evil))
  (define (build-kmp s)
    (define n (string-length s))
    (define lps (make-vector n 0))
    (let loop ([len 0] [i 1])
      (when (< i n)
        (if (equal? (string-ref s i) (string-ref s len))
            (begin
              (vector-set! lps i (+ len 1))
              (loop (+ len 1) (+ i 1)))
            (if (zero? len)
                (begin
                  (vector-set! lps i 0)
                  (loop len (+ i 1)))
                (loop (vector-ref lps (- len 1)) i)))))
    lps)
  (define evil-lps (build-kmp evil))
  (define (solve s)
    (define memo (make-hash))
    (define (dp pos matched is-less)
      (define key (list pos matched is-less))
      (hash-ref! memo key
                 (lambda ()
                   (cond
                     [(= matched m) 0]
                     [(= pos n) 1]
                     [else
                      (define current-char (string-ref s pos))
                      (define limit (if is-less
                                       (char->integer #\z)
                                       (char->integer current-char)))
                      (let loop ([c (char->integer #\a)] [total 0])
                        (if (> c limit)
                            (modulo total mod)
                            (let* ([new-matched matched]
                                   [new-is-less (or is-less (< c limit))])
                              (while (and (> new-matched 0)
                                          (not (equal? (integer->char c)
                                                       (string-ref evil new-matched))))
                                (set! new-matched (vector-ref evil-lps (- new-matched 1))))
                              (if (equal? (integer->char c)
                                          (string-ref evil new-matched))
                                  (set! new-matched (+ new-matched 1))
                                  (set! new-matched 0))
                              (loop (+ c 1)
                                    (+ total (dp (+ pos 1) new-matched new-is-less))))))]))))
    (dp 0 0 #f))
  (define (count-less s)
    (define res 0)
    (define matched 0)
    (for ([i (in-range n)])
      (define c (string-ref s i))
      (for ([d (in-range (char->integer #\a) (char->integer c))])
        (define new-matched matched)
        (while (and (> new-matched 0)
                    (not (equal? (integer->char d)
                                 (string-ref evil new-matched))))
          (set! new-matched (vector-ref evil-lps (- new-matched 1))))
        (if (equal? (integer->char d)
                    (string-ref evil new-matched))
            (set! new-matched (+ new-matched 1))
            (set! new-matched 0))
        (when (< new-matched m)
          (set! res (modulo (+ res (solve (substring s 0 i)
                                         new-matched
                                         #t)) mod))))
      (while (and (> matched 0)
                  (not (equal? c (string-ref evil matched))))
        (set! matched (vector-ref evil-lps (- matched 1))))
      (if (equal? c (string-ref evil matched))
          (set! matched (+ matched 1))
          (set! matched 0))
      (when (>= matched m)
        (set! res 0)
        (break)))
    res)
  (define count-s1 (count-less s1))
  (define count-s2 (count-less s2))
  (define has-evil1 #f)
  (define has-evil2 #f)
  (define matched 0)
  (for ([c (in-string s1)])
    (while (and (> matched 0)
                (not (equal? c (string-ref evil matched))))
      (set! matched (vector-ref evil-lps (- matched 1))))
    (if (equal? c (string-ref evil matched))
        (set! matched (+ matched 1))
        (set! matched 0))
    (when (>= matched m)
      (set! has-evil1 #t)
      (break)))
  (set! matched 0)
  (for ([c (in-string s2)])
    (while (and (> matched 0)
                (not (equal? c (string-ref evil matched))))
      (set! matched (vector-ref evil-lps (- matched 1))))
    (if (equal? c (string-ref evil matched))
        (set! matched (+ matched 1))
        (set! matched 0))
    (when (>= matched m)
      (set! has-evil2 #t)
      (break)))
  (define total (modulo (- (+ count-s2 (if has-evil2 0 1))
                           count-s1)
                        mod))
  (if (< total 0)
      (+ total mod)
      total))