(define (entity-parser text)
  (let loop ((i 0) (res '()))
    (cond
      ((>= i (string-length text))
      (list->string (reverse res))
      ((and (<= (+ i 3) (string-length text))
            (string=? (substring text i (+ i 4)) "&gt;"))
       (loop (+ i 4) (cons #\> res)))
      ((and (<= (+ i 3) (string-length text))
            (string=? (substring text i (+ i 4)) "&lt;"))
       (loop (+ i 4) (cons #\< res)))
      ((and (<= (+ i 4) (string-length text))
            (string=? (substring text i (+ i 5)) "&amp;"))
       (loop (+ i 5) (cons #\& res)))
      ((and (<= (+ i 5) (string-length text))
            (string=? (substring text i (+ i 6)) "&quot;"))
       (loop (+ i 6) (cons #\" res)))
      ((and (<= (+ i 5) (string-length text))
            (string=? (substring text i (+ i 6)) "&apos;"))
       (loop (+ i 6) (cons #\' res)))
      (else
       (loop (+ i 1) (cons (string-ref text i) res))))))