(define/contract (find-min-fibonacci-numbers k)
  (-> exact-integer? exact-integer?)
  (let loop ([fibs (list 1 1)] [k k] [count 0])
    (let ([next-fib (+ (first fibs) (second fibs))])
      (if (> next-fib k)
          (let ([fibs (cons next-fib fibs)])
            (loop fibs k count))
          (if (<= (first fibs) k)
              (loop (cdr fibs) (- k (first fibs)) (+ count 1))
              (loop (cdr fibs) k count))))))