(define/contract (largest-number cost target)
  (-> (listof exact-integer?) exact-integer? string?)
  (let loop ([remaining target] [memo (make-hash)])
    (if (zero? remaining)
        ""
        (if (hash-has-key? memo remaining)
            (hash-ref memo remaining)
            (let ([max-str "-1"])
              (for ([i (in-range 9 0 -1)])
                (let ([c (list-ref cost (sub1 i))])
                  (when (<= c remaining)
                    (let ([res (loop (- remaining c) memo)])
                      (unless (string=? res "-1")
                        (let ([new-str (string-append (number->string i) res)])
                          (when (or (string=? max-str "-1")
                                    (> (string-length new-str) (string-length max-str))
                                    (and (= (string-length new-str) (string-length max-str))
                                         (string>? new-str max-str)))
                            (set! max-str new-str))))))))
              (hash-set! memo remaining max-str)
              max-str)))))