(define/contract (min-cost houses cost m n target)
  (-> (listof exact-integer?) (listof (listof exact-integer?)) exact-integer? exact-integer? exact-integer? exact-integer?)
  (let* ([m (length houses)]
         [n (if (null? cost) 0 (length (car cost)))]
         [dp (make-vector (+ m 1) (make-vector (+ target 1) (make-vector (+ n 1) +inf.0)))]
         [houses (list->vector houses)]
         [cost (list->vector (map list->vector cost))])
    (for ([i (in-range 1 (+ n 1))])
      (vector-set! (vector-ref (vector-ref dp 0) 0) i 0)
    )
    (for ([i (in-range 1 (+ m 1))])
      (for ([k (in-range 1 (+ target 1))])
        (for ([prev-color (in-range 1 (+ n 1))])
          (if (not (zero? (vector-ref houses (- i 1))))
              (let ([curr-color (vector-ref houses (- i 1))])
                (if (= curr-color prev-color)
                    (let ([val (vector-ref (vector-ref (vector-ref dp (- i 1)) k) prev-color)])
                      (vector-set! (vector-ref (vector-ref dp i) k) curr-color
                        (min (vector-ref (vector-ref (vector-ref dp i) k) curr-color) val))
                    (if (> k 1)
                        (let ([val (vector-ref (vector-ref (vector-ref dp (- i 1)) (- k 1)) prev-color)])
                          (vector-set! (vector-ref (vector-ref dp i) k) curr-color
                            (min (vector-ref (vector-ref (vector-ref dp i) k) curr-color) val))
                        )
                        #f)
                )
              )
              (for ([curr-color (in-range 1 (+ n 1))])
                (if (= curr-color prev-color)
                    (let ([val (+ (vector-ref (vector-ref (vector-ref dp (- i 1)) k) prev-color)
                                   (vector-ref (vector-ref cost (- i 1)) (- curr-color 1)))])
                      (vector-set! (vector-ref (vector-ref dp i) k) curr-color
                        (min (vector-ref (vector-ref (vector-ref dp i) k) curr-color) val))
                    (if (> k 1)
                        (let ([val (+ (vector-ref (vector-ref (vector-ref dp (- i 1)) (- k 1)) prev-color)
                                       (vector-ref (vector-ref cost (- i 1)) (- curr-color 1)))])
                          (vector-set! (vector-ref (vector-ref dp i) k) curr-color
                            (min (vector-ref (vector-ref (vector-ref dp i) k) curr-color) val))
                        #f)
                )
              )
          )
        )
      )
    )
    (let ([res (apply min (vector->list (vector-ref (vector-ref (vector-ref dp m) target))))])
      (if (equal? res +inf.0) -1 res))
  )
)