(define/contract (min-sum-of-lengths arr target)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (define n (length arr))
  (define prefix (make-hash))
  (hash-set! prefix 0 -1)
  (define left-min (make-vector n +inf.0))
  (define sum 0)
  (define min-len +inf.0)
  (define result +inf.0)

  (for ([i (in-range n)])
    (set! sum (+ sum (list-ref arr i)))
    (hash-set! prefix sum i)
    (when (hash-has-key? prefix (- sum target))
      (define prev (hash-ref prefix (- sum target)))
      (define curr-len (- i prev))
      (when (> prev -1)
        (when (< (vector-ref left-min prev) +inf.0)
          (set! result (min result (+ (vector-ref left-min prev) curr-len)))))
      (set! min-len (min min-len curr-len)))
    (vector-set! left-min i min-len))

  (if (= result +inf.0) -1 result))