(define (find-critical-and-pseudo-critical-edges n edges)
  (define m (length edges))
  (define indexed-edges (for/list ([e edges] [i (in-naturals)]) (append e (list i))))
  (define (kruskal edges-to-use excluded-edge)
    (define parent (make-vector n))
    (for ([i (in-range n)]) (vector-set! parent i i))
    (define (find u)
      (if (= (vector-ref parent u) u)
          u
          (begin (vector-set! parent u (find (vector-ref parent u))) (vector-ref parent u)))
    (define (union u v)
      (let ([pu (find u)] [pv (find v)])
        (when (not (= pu pv)) (vector-set! parent pu pv))))
    (define weight 0)
    (define count 0)
    (when (not (null? excluded-edge))
      (let ([e (car excluded-edge)])
        (union (car e) (cadr e))
        (set! weight (+ weight (caddr e)))
        (set! count (+ count 1))))
    (for ([e (sort edges-to-use (lambda (a b) (< (caddr a) (caddr b))))])
      (when (>= count (- n 1)) (break))
      (let ([u (car e)] [v (cadr e)] [w (caddr e)])
        (when (not (= (find u) (find v)))
          (union u v)
          (set! weight (+ weight w))
          (set! count (+ count 1)))))
    (if (= count (- n 1)) weight +inf.0))
  (define original-edges (sort (copy-list indexed-edges) (lambda (a b) (< (caddr a) (caddr b)))))
  (define mst-weight (kruskal original-edges null))
  (define critical '())
  (define pseudo '())
  (for ([e indexed-edges])
    (define idx (cadddr e))
    (define new-edges (filter (lambda (x) (not (= (cadddr x) idx))) original-edges))
    (define new-weight (kruskal new-edges null))
    (if (> new-weight mst-weight)
        (set! critical (cons idx critical))
        (begin
          (define forced-weight (kruskal new-edges e))
          (if (= forced-weight mst-weight)
              (set! pseudo (cons idx pseudo))
              '()))))
  (list (sort critical <) (sort pseudo <)))