(define (min-integer num k)
  (let* ((s (string->list (number->string num)))
         (n (length s)))
    (let loop ((i 0) (k k) (s s))
      (if (or (>= i n) (<= k 0))
          (string->number (list->string s))
          (let ((min-pos (find-min-pos s i (min (+ i k) (- n 1)))))
            (let ((min-char (list-ref s min-pos)))
              (loop (+ i 1)
                    (- k (- min-pos i))
                    (move-to-front s i min-pos))))))))

(define (find-min-pos s start end)
  (let loop ((i start) (min-pos start) (min-char (list-ref s start)))
    (if (> i end)
        min-pos
        (let ((c (list-ref s i)))
          (if (char<? c min-char)
              (loop (+ i 1) i c)
              (loop (+ i 1) min-pos min-char))))))

(define (move-to-front s start pos)
  (let ((c (list-ref s pos)))
    (append (take s start)
            (list c)
            (take (drop s (+ start 1)) (- pos start))
            (drop s (+ pos 1)))))