(define/contract (range-sum nums n left right)
  (-> (listof exact-integer?) exact-integer? exact-integer? exact-integer? exact-integer?)
  (define subarray-sums '())
  (for ([i (in-range n)])
    (for ([j (in-range i n)])
      (define sum (apply + (take (drop nums i) (+ (- j i) 1))))
      (set! subarray-sums (cons sum subarray-sums)))
  (define sorted-sums (sort subarray-sums <))
  (define result 0)
  (for ([i (in-range (- left 1) right)])
    (set! result (+ result (list-ref sorted-sums i))))
  result)