(define/contract (winner-square-game n)
  (-> exact-integer? boolean?)
  (let ([dp (make-vector (+ n 1) #f)])
    (for ([i (in-range 1 (+ n 1))])
      (for ([k (in-range 1 (inexact->exact (floor (sqrt i)))])
        (when (not (vector-ref dp (- i (* k k))))
          (vector-set! dp i #t)
          (break))))
    (vector-ref dp n)))