(define/contract (closest-to-target arr target)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (define n (length arr))
  (define vec (list->vector arr))
  (define result +inf.0)
  (define (bitwise-and-range i j)
    (let loop ([k i] [current (vector-ref vec i)])
      (if (> k j)
          current
          (loop (add1 k) (bitwise-and current (vector-ref vec k))))))
  (for ([i (in-range n)])
    (for ([j (in-range i n)])
      (define val (bitwise-and-range i j))
      (define diff (abs (- val target)))
      (when (< diff (abs (- result target)))
        (set! result val))
      (when (= diff (abs (- result target)))
        (when (< val result)
          (set! result val))))
      (when (= val 0)
        (break)))
  (inexact->exact result))