(define/contract (min-swaps grid)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define n (length grid))
  (define zeros-right (make-vector n 0))
  (for ([i (in-range n)])
    (define row (list-ref grid i))
    (define cnt 0)
    (for ([j (in-range (sub1 n) -1 -1)])
      (if (zero? (list-ref row j))
          (set! cnt (add1 cnt))
          (break)))
    (vector-set! zeros-right i cnt))
  (define res 0)
  (for ([i (in-range n)])
    (define needed (- n i 1))
    (define j i)
    (while (and (< j n) (< (vector-ref zeros-right j) needed))
      (set! j (add1 j)))
    (if (= j n)
        (begin (set! res -1) (break))
        (begin
          (set! res (+ res (- j i)))
          (while (> j i)
            (vector-set! zeros-right j (vector-ref zeros-right (sub1 j)))
            (set! j (sub1 j))))))
  res)