(define/contract (can-convert-string s t k)
  (-> string? string? exact-integer? boolean?)
  (let ((n (string-length s)))
    (if (not (= n (string-length t)))
        #f
        (let loop ((i 0)
                   (counts (make-hash)))
          (if (= i n)
              (let ((max-move 0)
                    (max-count 0))
                (hash-for-each counts (lambda (move cnt)
                  (let ((required-move (+ move (* 26 (sub1 cnt)))))
                    (when (> required-move max-move)
                      (set! max-move required-move)
                      (set! max-count cnt)))))
                (<= max-move k))
              (let ((sc (char->integer (string-ref s i)))
                    (tc (char->integer (string-ref t i))))
                (if (= sc tc)
                    (loop (add1 i) counts)
                    (let ((move (modulo (- tc sc) 26)))
                      (if (= move 0)
                          (loop (add1 i) counts)
                          (loop (add1 i) (hash-update counts move add1 1))))))))))))