(define/contract (find-latest-step arr m)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (let* ([n (length arr)]
         [parent (make-vector (+ n 2) 0)]
         [size (make-vector (+ n 2) 0)]
         [count (make-hash)]
         [result -1])
    (define (find u)
      (if (= (vector-ref parent u) u)
          u
          (let ([p (find (vector-ref parent u))])
            (vector-set! parent u p)
            p)))
    (define (union u v)
      (let ([pu (find u)]
            [pv (find v)])
        (when (not (= pu pv))
          (hash-set! count (vector-ref size pu) (- (hash-ref count (vector-ref size pu) 0) 1))
          (hash-set! count (vector-ref size pv) (- (hash-ref count (vector-ref size pv) 0) 1))
          (vector-set! parent pv pu)
          (vector-set! size pu (+ (vector-ref size pu) (vector-ref size pv)))
          (hash-set! count (vector-ref size pu) (+ (hash-ref count (vector-ref size pu) 0) 1))
    (for ([i (in-range 1 (+ n 1))])
      (vector-set! parent i i)
      (vector-set! size i 0))
    (hash-set! count 0 n)
    (for ([step (in-range 1 (+ n 1))])
      (let ([pos (list-ref arr (- step 1))])
        (vector-set! size pos 1)
        (hash-set! count 1 (+ (hash-ref count 1 0) 1))
        (hash-set! count 0 (- (hash-ref count 0 0) 1))
        (when (> pos 1)
          (if (> (vector-ref size (- pos 1)) 0)
              (union pos (- pos 1))
              (void)))
        (when (< pos n)
          (if (> (vector-ref size (+ pos 1)) 0)
              (union pos (+ pos 1))
              (void)))
        (if (> (hash-ref count m 0) 0)
            (set! result step)
            (void))))
    result))