(define/contract (num-special mat)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (let ([rows (length mat)]
        [cols (if (null? mat) 0 (length (car mat)))])
    (let ([row-count (make-vector rows 0)]
          [col-count (make-vector cols 0)])
      (for ([i (in-range rows)])
        (for ([j (in-range cols)])
          (when (= (list-ref (list-ref mat i) j) 1)
            (vector-set! row-count i (add1 (vector-ref row-count i)))
            (vector-set! col-count j (add1 (vector-ref col-count j))))))
      (let ([res 0])
        (for ([i (in-range rows)])
          (for ([j (in-range cols)])
            (when (and (= (list-ref (list-ref mat i) j) 1)
                       (= (vector-ref row-count i) 1)
                       (= (vector-ref col-count j) 1))
              (set! res (add1 res)))))
        res))))