(define/contract (unhappy-friends n preferences pairs)
  (-> exact-integer? (listof (listof exact-integer?)) (listof (listof exact-integer?)) exact-integer?)
  (define pair-map (make-hash))
  (for ([pair pairs])
    (hash-set! pair-map (first pair) (second pair))
    (hash-set! pair-map (second pair) (first pair)))

  (define (is-unhappy? x)
    (define y (hash-ref pair-map x))
    (define x-pref (list-ref preferences x))
    (define y-pref (list-ref preferences y))
    (define x-y-index (index-of x-pref y))
    (for/or ([u x-pref])
      (define u-index (index-of x-pref u))
      (and (< u-index x-y-index)
           (let ([v (hash-ref pair-map u)])
             (define u-pref (list-ref preferences u))
             (define v-index (index-of u-pref v))
             (define x-index (index-of u-pref x))
             (< x-index v-index))))))

  (for/sum ([x (in-range n)])
    (if (is-unhappy? x) 1 0)))