(define/contract (is-transformable s t)
  (-> string? string? boolean?)
  (let ((s-vec (list->vector (map (lambda (c) (- (char->integer c) (char->integer #\0))) (string->list s))))
        (t-vec (list->vector (map (lambda (c) (- (char->integer c) (char->integer #\0))) (string->list t))))
        (n (vector-length s-vec))
        (pos (make-vector 10 '())))
    (for ([i (in-range n)])
      (let ((digit (vector-ref s-vec i)))
        (vector-set! pos digit (cons i (vector-ref pos digit)))))
    (for ([i (in-range n)])
      (let ((digit (vector-ref t-vec i)))
        (if (null? (vector-ref pos digit))
            #f
            (let ((min-pos (car (vector-ref pos digit))))
                (for ([d (in-range digit)])
                  (if (and (not (null? (vector-ref pos d))) (< (car (vector-ref pos d)) min-pos))
                      #f
                      (void)))
                (vector-set! pos digit (cdr (vector-ref pos digit))))))
    #t))