(define/contract (max-sum-range-query nums requests)
  (-> (listof exact-integer?) (listof (listof exact-integer?)) exact-integer?)
  (define n (length nums))
  (define diff (make-vector (add1 n) 0))
  (for ([req requests])
    (define start (first req))
    (define end (second req))
    (vector-set! diff start (add1 (vector-ref diff start)))
    (when (< end (sub1 n))
      (vector-set! diff (add1 end) (sub1 (vector-ref diff (add1 end))))))
  (define freq (make-vector n 0))
  (define current 0)
  (for ([i (in-range n)])
    (set! current (+ current (vector-ref diff i)))
    (vector-set! freq i current))
  (define sorted-nums (sort nums >))
  (define sorted-freq (sort (vector->list freq) >))
  (define sum 0)
  (for ([i (in-range n)])
    (set! sum (+ sum (* (list-ref sorted-nums i) (list-ref sorted-freq i)))))
  (modulo sum (expt 10 9 7)))