#lang racket

(define (max-product-path grid)
  (define m (length grid))
  (define n (length (car grid)))
  (define dp (make-vector m (make-vector n (cons 1 1))))

  (vector-set! (vector-ref dp 0) 0 (cons (caar grid) (caar grid)))

  (for ([i (in-range m)])
    (for ([j (in-range n)])
      (unless (and (= i 0) (= j 0))
        (define current (list-ref (list-ref grid i) j))
        (define max-val -inf.0)
        (define min-val +inf.0)
        (when (> i 0)
          (define up (vector-ref (vector-ref dp (- i 1)) j))
          (define val1 (* (car up) current))
          (define val2 (* (cdr up) current))
          (set! max-val (max max-val val1 val2))
          (set! min-val (min min-val val1 val2))
        )
        (when (> j 0)
          (define left (vector-ref (vector-ref dp i) (- j 1)))
          (define val1 (* (car left) current))
          (define val2 (* (cdr left) current))
          (set! max-val (max max-val val1 val2))
          (set! min-val (min min-val val1 val2))
        )
        (vector-set! (vector-ref dp i) j (cons max-val min-val))
      )
    )
  )

  (define result (car (vector-ref (vector-ref dp (- m 1)) (- n 1))))
  (if (>= result 0)
      (modulo result 1000000007)
      -1)
)