(define/contract (restore-matrix rowSum colSum)
  (-> (listof exact-integer?) (listof exact-integer?) (listof (listof exact-integer?)))
  (define rows (length rowSum))
  (define cols (length colSum))
  (define matrix (for/list ([i (in-range rows)])
                   (make-list cols 0)))
  (let loop ([i 0] [j 0])
    (when (and (< i rows) (< j cols))
      (let ([min-val (min (list-ref rowSum i) (list-ref colSum j))])
        (list-set! (list-ref matrix i) j min-val)
        (list-set! rowSum i (- (list-ref rowSum i) min-val))
        (list-set! colSum j (- (list-ref colSum j) min-val))
        (if (zero? (list-ref rowSum i))
            (loop (add1 i) j)
            (loop i (add1 j))))))
  matrix)