(define/contract (busiest-servers k requests)
  (-> exact-integer? (listof exact-integer?) (listof exact-integer?))
  (define available (make-heap (lambda (a b) (<= a b))))
  (for ([i (in-range k)])
    (heap-add! available i))
  (define busy (make-heap (lambda (a b) (<= (car a) (car b)))))
  (define count (make-vector k 0))
  (for ([time (in-list requests)] [i (in-naturals)])
    (let loop ()
      (when (and (not (heap-empty? busy)) (<= (car (heap-min busy)) time))
        (heap-add! available (modulo (+ (cdr (heap-remove-min! busy)) (- k (modulo i k))) k))
        (loop)))
    (if (heap-empty? available)
        (void)
        (let ([server (heap-remove-min! available)])
          (heap-add! busy (cons (+ time (list-ref requests i)) server))
          (vector-set! count server (add1 (vector-ref count server))))))
  (define max-count (apply max (vector->list count)))
  (for/list ([(server cnt) (in-indexed (vector->list count))] #:when (= cnt max-count))
    server))