#lang racket

(define (count-subtrees-max-distance-between-cities n edges)
  (define adj (make-vector n '()))
  (for ([edge edges])
    (let ([u (sub1 (first edge))]
          [v (sub1 (second edge))])
      (vector-set! adj u (cons v (vector-ref adj u)))
      (vector-set! adj v (cons u (vector-ref adj v)))))

  (define (get-max-dist mask)
    (define max-dist 0)
    (define node-count 0)
    (for ([i n] #:when (bitwise-bit-set? mask i))
      (set! node-count (add1 node-count)))
    (when (< node-count 2)
      (return (cons 0 1)))
    (define (bfs start)
      (define dist (make-vector n -1))
      (define q (make-queue))
      (enqueue! q start)
      (vector-set! dist start 0)
      (define last-node start)
      (define max-d 0)
      (let loop ()
        (unless (queue-empty? q)
          (define u (dequeue! q))
          (for ([v (vector-ref adj u)] #:when (and (bitwise-bit-set? mask v) (= (vector-ref dist v) -1)))
            (vector-set! dist v (add1 (vector-ref dist u)))
            (when (> (vector-ref dist v) max-d)
              (set! max-d (vector-ref dist v))
              (set! last-node v))
            (enqueue! q v))
          (loop)))
      (cons last-node max-d))
    (define start-node
      (for/first ([i n] #:when (bitwise-bit-set? mask i)) i))
    (define first-bfs (bfs start-node))
    (define second-bfs (bfs (car first-bfs)))
    (cons (cdr second-bfs) node-count))

  (define max-d 0)
  (define count 0)
  (for ([mask (in-range 1 (arithmetic-shift 1 n))])
    (define res (get-max-dist mask))
    (define current-max (car res))
    (define current-count (cdr res))
    (cond
      [(> current-max max-d)
       (set! max-d current-max)
       (set! count 1)]
      [(= current-max max-d)
       (set! count (add1 count))]))
  (define result (make-vector (add1 max-d) 0))
  (vector-set! result max-d count)
  result)