(define/contract (best-team-score scores ages)
  (-> (listof exact-integer?) (listof exact-integer?) exact-integer?)
  (define n (length scores))
  (define players (for/list ([s scores] [a ages]) (cons a s)))
  (define sorted-players (sort players (lambda (x y) (or (< (car x) (car y)) (and (= (car x) (car y)) (< (cdr x) (cdr y)))))))
  (define dp (make-vector n 0))
  (for ([i (in-range n)])
    (vector-set! dp i (cdr (list-ref sorted-players i)))
  )
  (for ([i (in-range n)])
    (for ([j (in-range i)])
      (when (<= (cdr (list-ref sorted-players j)) (cdr (list-ref sorted-players i)))
        (vector-set! dp i (max (vector-ref dp i) (+ (vector-ref dp j) (cdr (list-ref sorted-players i)))))
      )
    )
  )
  (apply max (vector->list dp))
)