(define/contract (minimum-effort-path heights)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define rows (length heights))
  (define cols (if (null? heights) 0 (length (car heights))))
  (define dirs '((0 1) (1 0) (0 -1) (-1 0)))
  (define efforts (make-vector (* rows cols) +inf.0))
  (define pq (make-priority-queue (lambda (a b) (< (car a) (car b))))

  (vector-set! efforts 0 0)
  (priority-queue-push! pq (cons 0 0))

  (let loop ()
    (unless (priority-queue-empty? pq)
      (define current (priority-queue-pop! pq))
      (define current-effort (car current))
      (define pos (cdr current))
      (define i (quotient pos cols))
      (define j (remainder pos cols))

      (when (and (= i (sub1 rows)) (= j (sub1 cols)))
        (return current-effort))

      (for ([dir dirs])
        (define ni (+ i (car dir)))
        (define nj (+ j (cadr dir)))
        (when (and (>= ni 0) (< ni rows) (>= nj 0) (< nj cols))
          (define new-effort (max current-effort
                                 (abs (- (list-ref (list-ref heights i) j)
                                       (list-ref (list-ref heights ni) nj)))))
          (define new-pos (+ (* ni cols) nj))
          (when (< new-effort (vector-ref efforts new-pos))
            (vector-set! efforts new-pos new-effort)
            (priority-queue-push! pq (cons new-effort new-pos))))))
      (loop)))
  0)