(define (matrix-rank-transform matrix)
  (define rows (length matrix))
  (if (zero? rows) '()
      (let* ((cols (length (car matrix)))
             (coords (for*/list ([i (in-range rows)] [j (in-range cols)]) (cons i j)))
             (groups (make-hash))
             (uf (make-vector (* rows cols) -1)))
        (define (find x)
          (if (< (vector-ref uf x) 0) x
              (let ((root (find (vector-ref uf x))))
                (vector-set! uf x root)
                root)))
        (define (union x y)
          (let ((x-root (find x))
                (y-root (find y)))
            (unless (equal? x-root y-root)
              (if (< (vector-ref uf x-root) (vector-ref uf y-root))
                  (begin
                    (vector-set! uf x-root (+ (vector-ref uf x-root) (vector-ref uf y-root)))
                    (vector-set! uf y-root x-root))
                  (begin
                    (vector-set! uf y-root (+ (vector-ref uf y-root) (vector-ref uf x-root)))
                    (vector-set! uf x-root y-root))))))
        (for ([i (in-range rows)])
        (for ([j (in-range cols)])
          (let ((val (list-ref (list-ref matrix i) j)))
            (unless (hash-has-key? groups val)
              (hash-set! groups val '()))
            (hash-set! groups val (cons (cons i j) (hash-ref groups val '()))))
        (for ([val (sort (hash-keys groups) <)])
          (let ((group (hash-ref groups val)))
            (for ([coord group])
              (let ((i (car coord))
                    (j (cdr coord)))
                (for ([d '((0 . 1) (1 . 0))])
                  (let ((ni (+ i (car d)))
                        (nj (+ j (cdr d))))
                    (when (and (>= ni 0) (< ni rows) (>= nj 0) (< nj cols))
                      (let ((current-val (list-ref (list-ref matrix i) j))
                            (neighbor-val (list-ref (list-ref matrix ni) nj)))
                        (when (<= neighbor-val current-val)
                          (union (+ (* i cols) j) (+ (* ni cols) nj))))))))))
            (let ((rank (make-hash)))
              (for ([coord group])
                (let ((root (find (+ (* (car coord) cols) (cdr coord)))))
                  (hash-set! rank root (max (hash-ref rank root 0) 
                                           (for/max ([d '((0 . 1) (1 . 0))])
                                             (let ((ni (+ (car coord) (car d)))
                                                   (nj (+ (cdr coord) (cdr d))))
                                               (if (and (>= ni 0) (< ni rows) (>= nj 0) (< nj cols))
                                                   (let ((neighbor-val (list-ref (list-ref matrix ni) nj)))
                                                     (if (< neighbor-val val) 
                                                         (add1 (list-ref (list-ref result ni) nj))
                                                         0))
                                                   0)))))))
              (for ([coord group])
                (let* ((i (car coord))
                       (j (cdr coord))
                       (root (find (+ (* i cols) j)))
                       (current-rank (hash-ref rank root)))
                  (list-set! (list-ref result i) j current-rank)))))
        result)))