(define (count-substrings s t)
  (define (helper i j)
    (if (or (< i 0) (< j 0) (>= i (string-length s)) (>= j (string-length t)))
        0
        (if (char=? (string-ref s i) (string-ref t j))
            (helper (sub1 i) (sub1 j))
            1)))
  (define (count i j)
    (let loop ((i i) (j j) (res 0) (diff 0))
        (if (or (>= i (string-length s)) (>= j (string-length t)) (>= diff 2))
            res
            (let ((new-diff (+ diff (if (char=? (string-ref s i) (string-ref t j)) 0 1))))
              (if (= new-diff 1)
                  (loop (add1 i) (add1 j) (add1 res) new-diff)
                  (loop (add1 i) (add1 j) res new-diff)))))
  (let ((res 0))
    (for ((i (in-range (string-length s))))
      (set! res (+ res (count i 0))))
    (for ((j (in-range 1 (string-length t))))
      (set! res (+ res (count 0 j))))
    res))