(define/contract (max-height cuboids)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define (sorted-cuboid cuboid)
    (sort cuboid <))
  (define sorted-cuboids (map sorted-cuboid cuboids))
  (define sorted (sort sorted-cuboids (lambda (a b)
                                       (if (= (car a) (car b))
                                           (if (= (cadr a) (cadr b))
                                               (< (caddr a) (caddr b))
                                               (< (cadr a) (cadr b)))
                                           (< (car a) (car b))))))
  (define n (length sorted))
  (define dp (make-vector n 0))
  (for ([i (in-range n)])
    (vector-set! dp i (caddr (list-ref sorted i)))
  (for ([i (in-range n)])
    (for ([j (in-range i)])
      (when (and (<= (car (list-ref sorted j)) (car (list-ref sorted i))
                 (<= (cadr (list-ref sorted j)) (cadr (list-ref sorted i)))
                 (<= (caddr (list-ref sorted j)) (caddr (list-ref sorted i))))
        (vector-set! dp i (max (vector-ref dp i)
                               (+ (vector-ref dp j) (caddr (list-ref sorted i))))))))
  (apply max (vector->list dp)))