(define/contract (maximum-unique-subarray nums)
  (-> (listof exact-integer?) exact-integer?)
  (define n (length nums))
  (define max-sum 0)
  (define current-sum 0)
  (define seen (make-hash))
  (define left 0)

  (for ([right (in-range n)])
    (define num (list-ref nums right))
    (when (hash-has-key? seen num)
      (define last-pos (hash-ref seen num))
      (while (<= left last-pos)
        (define left-num (list-ref nums left))
        (hash-remove! seen left-num)
        (set! current-sum (- current-sum left-num))
        (set! left (add1 left))))
    (hash-set! seen num right)
    (set! current-sum (+ current-sum num))
    (set! max-sum (max max-sum current-sum)))
  max-sum)