(define/contract (count-pairs deliciousness)
  (-> (listof exact-integer?) exact-integer?)
  (define MOD 1000000007)
  (define max-sum (foldl max 0 deliciousness))
  (define max-power (if (zero? max-sum) 0 (add1 (exact-floor (/ (log max-sum) (log 2))))))
  (define power-list (for/list ([i (in-range (add1 max-power))]) (expt 2 i)))
  (define freq (make-hash))
  (define res 0)
  (for ([num deliciousness])
    (for ([power power-list])
      (define target (- power num))
      (set! res (modulo (+ res (hash-ref freq target 0)) MOD)))
    (hash-update! freq num add1 0))
  res)