(define/contract (min-characters a b)
  (-> string? string? exact-integer?)
  (define (count-freq s)
    (define freq (make-vector 26 0))
    (for ([c s])
      (vector-set! freq (- (char->integer c) (char->integer #\a)) 
                   (add1 (vector-ref freq (- (char->integer c) (char->integer #\a))))))
    freq)
  (define freq-a (count-freq a))
  (define freq-b (count-freq b))
  (define len-a (string-length a))
  (define len-b (string-length b))
  (define (prefix-sum vec)
    (define ps (make-vector 26 0))
    (vector-set! ps 0 (vector-ref vec 0))
    (for ([i (in-range 1 26)])
      (vector-set! ps i (+ (vector-ref ps (sub1 i)) (vector-ref vec i))))
    ps)
  (define ps-a (prefix-sum freq-a))
  (define ps-b (prefix-sum freq-b))
  (define min-changes +inf.0)
  ; condition 1: a < b
  (for ([i (in-range 1 26)])
    (set! min-changes (min min-changes (+ (- len-a (vector-ref ps-a (sub1 i))) (vector-ref ps-b (sub1 i))))))
  ; condition 2: b < a
  (for ([i (in-range 1 26)])
    (set! min-changes (min min-changes (+ (- len-b (vector-ref ps-b (sub1 i))) (vector-ref ps-a (sub1 i))))))
  ; condition 3: all same letter
  (for ([i (in-range 26)])
    (set! min-changes (min min-changes (+ (- len-a (vector-ref freq-a i)) (- len-b (vector-ref freq-b i))))))
  min-changes)