(define (kth-largest-value matrix k)
  (let* ((m (length matrix))
         (n (if (null? matrix) 0 (length (car matrix))))
         (xor-matrix (make-vector m (make-vector n 0)))
         (result '()))
    (for ([i (in-range m)])
      (for ([j (in-range n)])
        (let ((top (if (> i 0) (vector-ref (vector-ref xor-matrix (- i 1)) j) 0))
              (left (if (> j 0) (vector-ref (vector-ref xor-matrix i) (- j 1)) 0))
              (topleft (if (and (> i 0) (> j 0)) (vector-ref (vector-ref xor-matrix (- i 1)) (- j 1)) 0)))
          (vector-set! (vector-ref xor-matrix i) j
                       (bitwise-xor (vector-ref (vector-ref (list->vector matrix) i) j)
                                    (bitwise-xor top (bitwise-xor left topleft))))
        (set! result (cons (vector-ref (vector-ref xor-matrix i) j) result))))
    (list-ref (sort result >) (- k 1))))