(define/contract (minimum-length s)
  (-> string? exact-integer?)
  (let loop ([left 0] [right (sub1 (string-length s))])
    (if (and (< left right) (char=? (string-ref s left) (string-ref s right)))
        (let ([c (string-ref s left)])
          (let ([new-left (let search-left ([l left])
                            (if (and (<= l right) (char=? (string-ref s l) c))
                                (search-left (add1 l))
                                l))]
                [new-right (let search-right ([r right])
                             (if (and (>= r left) (char=? (string-ref s r) c))
                                 (search-right (sub1 r))
                                 r))])
            (loop new-left new-right)))
        (add1 (- right left)))))